dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 240, 440, "assets/images/table/cruise_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 8, 200, 300, "assets/images/table/cruise_8", "assets/images/food/item_mark1", "B" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;


maxCoupleHappiness = 200;

-- Group 1

guest = LManager.GenGuest(female03);
guest.matchType = male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 5, 3000);

-- Group 2


guest = LManager.GenGuest(female02);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male04;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 10, 24000);


guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 11, 48000);

-- Group 3

guest = LManager.GenGuest(male01);
guest.matchType = female04;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female01;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 14, 60000);

-- Group 4


guest = LManager.GenGuest(aunt);
guest.matchType = uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table1;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(15, 18, 90000);

-- Group 5

guest = LManager.GenGuest(male01);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(19, 20, 125000);

-- Group 6


guest = LManager.GenGuest(female01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(21, 24, 180000);



LManager:AdjustGuestTolerance(130);



LManager:SetLevelSetting ("speakerDelay", 130000); 
LManager:SetLevelSetting ("speakerChance", 30);


LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 100000 );

LManager:SetLevelSetting ("bridesmaidsDelay", 70000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Set up the Level Settings
LManager:SetLevelNumber(3,10);
LManager:SetLevelScores(10000, 14000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/uptempo_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );

